/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.util;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;

public class Raytracer {
    public static Pair<Vec3, Vec3> getVectors(Entity entity) {
        float pitch = entity.m_146909_();
        float yaw = entity.m_146908_();
        Vec3 start = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        float f1 = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f4 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0;
        if (entity instanceof ServerPlayer) {
            d3 = ((ServerPlayer)entity).m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        }
        Vec3 end = start.m_82520_((double)f5 * d3, (double)f4 * d3, (double)f6 * d3);
        return Pair.of((Object)start, (Object)end);
    }

    public static AdvancedRayTraceResult<BlockHitResult> collisionRayTrace(BlockPos pos, Vec3 start, Vec3 end, Collection<AABB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult<BlockHitResult> hit = null;
        int i = -1;
        for (AABB aabb : boxes) {
            double d;
            AdvancedRayTraceResult<BlockHitResult> result;
            AdvancedRayTraceResult<BlockHitResult> advancedRayTraceResult = result = aabb == null ? null : Raytracer.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static AdvancedRayTraceResult<BlockHitResult> collisionRayTrace(BlockPos pos, Vec3 start, Vec3 end, AABB bounds, int subHit, Object hitInfo) {
        BlockHitResult result = AABB.m_82342_(Collections.singleton(bounds), (Vec3)start, (Vec3)end, (BlockPos)pos);
        if (result == null) {
            return null;
        }
        return new AdvancedRayTraceResult<BlockHitResult>(result, bounds);
    }

    public static boolean inclusiveContains(AABB aabb, Vec3 hit) {
        return hit.f_82479_ >= aabb.f_82288_ && hit.f_82479_ <= aabb.f_82291_ && hit.f_82480_ >= aabb.f_82289_ && hit.f_82480_ <= aabb.f_82292_ && hit.f_82481_ >= aabb.f_82290_ && hit.f_82481_ <= aabb.f_82293_;
    }

    public static class AdvancedRayTraceResult<T extends HitResult> {
        public final AABB bounds;
        public final T hit;

        public AdvancedRayTraceResult(T mop, AABB aabb) {
            this.hit = mop;
            this.bounds = aabb;
        }

        public double squareDistanceTo(Vec3 vec) {
            return this.hit.m_82450_().m_82557_(vec);
        }
    }
}

